package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.objects.Adder;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class IncreasedEND extends Modifier {

	private static String xmlID = "INCREASEDEND";

	public IncreasedEND(Element root) {
		super(root, IncreasedEND.xmlID);
	}

	@Override
	public String getColumn2Output() {
		String adderString = "";
		String ret = "";
		ret += getAlias();
		double val = getTotalValue();

		if ((getInput() != null) && (getInput().trim().length() > 0)) {
			if (ret.trim().length() > 0) {
				ret += " ";
			}
			ret += getInput();
		}
		ret = ret.trim();
		for (Modifier mod : getAssignedModifiers()) {
			ret += ", " + mod.getAlias();
		}
		if (getSelectedOption() != null) {
			ret += " (" + getSelectedOption().getAlias();
		}
		int index = 0;
		int parenCount = 0;
		while (ret.indexOf("(", index) >= 0) {
			parenCount++;
			index = ret.indexOf("(", index) + 1;
		}
		index = 0;
		while (ret.indexOf(")", index) >= 0) {
			parenCount--;
			index = ret.indexOf(")", index) + 1;
		}
		if (parenCount <= 0) {
			ret += " (";
		} else {
			ret += "; ";
		}
		for (Adder ad : getAssignedAdders()) {
			if (!ad.isSelected()) {
				continue;
			}
			if (ad.getColumn2Output().trim().length() > 0) {
				ret += ad.getColumn2Output().trim() + "; ";
			}
		}
		if (getComments().trim().length() > 0) {
			ret += getComments() + "; ";
		}
		if ((val > maxCost) && maxSet) {
			val = maxCost;
		}
		if ((val < minimumCost) && minSet) {
			val = minimumCost;
		}
		ret += getFraction(val) + ")";
		parenCount--;
		while (parenCount > 0) {
			ret += ")";
			parenCount--;
		}
		if (adderString.trim().length() > 0) {
			if (ret.trim().length() > 0) {
				ret += ", ";
			}
			ret += adderString;
		}
		return ret;
	}

	@Override
	public double getTotalValue() {
		double ret = super.getTotalValue();
		if (getProgenitor() != null) {
			GenericObject parent = getProgenitor();
			if (GenericObject.findObjectByID(parent.getAssignedModifiers(),
					"COSTSENDONLYTOACTIVATE") != null) {
				ret = ret / 2;
			}
		}
		return ret;
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (GenericObject
				.findObjectByID(o.getAssignedModifiers(), "REDUCEDEND") != null) {
			return getDisplay()
					+ " cannot be assigned to an ability with Reduced Endurance.";
		}
		if (o instanceof com.hero.objects.List) {
			return "";
		} else {
			if (o.getEndUsage() == 0) {
				return getDisplay()
						+ " cannot be applied to an ability which does not cost END.";
			} else {
				return "";
			}
		}
	}
}